/*
	Name:			XenoN Core GUI Component Header
	Version:		1.0
	Update:			2011-02-24
	Copyright:		Copyright  2007-2011 XenoN Core by PsichiX. All rights reserved.
	Author:			PsichiX
	Website:		http://www.xenon.psichix.com
	Description:	XenoN Core Framework GUI Component Header
*/

/*
	== EN ==
	This file is part of Xenon Core Framework.
	You may distribute it further, but you can not modify it.
	Please do not use in modified form.
	The principles of XenoN Core License available in the file LICENSE_CORE_EN.TXT or visit: http://www.xenon.psichix.com.

	== PL ==
	Ten plik jest czescia XenoN Core Framework.
	Mozesz go rozpowszechniac dalej, jednak nie mozesz go modyfikowac.
	Nalezy uzytkowac w nie zmodyfikowanej formie.
	Nalezy przestrzegac zasad Licencji XenoN Core dostepnej w pliku LICENSE_CORE_PL.TXT oraz na stronie: http://www.xenon.psichix.com.
*/

#ifndef XE_COMPONENT_GUI_H
#define XE_COMPONENT_GUI_H

#include "GdiPlus.h"
#pragma comment(lib,"GdiPlus.lib")

using namespace Gdiplus;

#include "../System/XenonCoreFramework.h"
#include "../Components/XeComponentApp.h"

namespace XeCore
{
//! Przestrzen nazw komponentow
namespace Com
{

class C_GUI_CONTROL;
class C_GUI_LOADER;
struct C_GUI_VARIABLE{int type;void* data;};

//! Definicja typu procedury zdarzenia.
typedef void(*C_GUI_EVENT)(XE_GUI::CONTROL*);

//! Klasa kontrolki interfejsu.
class C_GUI_CONTROL : public XE_GUI::CONTROL
{
public:
	//! Procedura obslugi zdarzen.
	void(*DoEventsProc)(XE_GUI::CONTROL*);
	//! Procedura rysowania wewnatrz kontrolki.
	void(*RenderInsideProc)(XE_GUI::CONTROL*);
	/*! Konstruktor domyslny. */
	C_GUI_CONTROL();
	/*! Obsuga zdarzen. */
	void DoEvents();
	/*! Renderowanie wewnatrz kontrolki. */
	void RenderInside();
};

//! Klasa loadera interfejsu.
class C_GUI_LOADER
{
public:
	/*! Wykonuje skrypt XIL (XenoN Interface Language).
	\param control Wskaznikna kontrolke ktorej dotyczy skrypt.
	\param text Tresc skryptu.
	\param gui Referencja na obiekt interfejsu.
	*/
	static void ExecuteActions(XE_GUI::CONTROL* control,char* text,XE_GUI& gui);
	/*! Laduje schemat kontrolek interfejsu.
	\param fname Sciezka do pliku XML schematu interfejsu.
	\param node Nazwa wezla ktory ma wczytac.
	\param eventprocs Referencja na kontener procedur zdarzen do przydzielenia kontrolkom.
	\param textures Referencjana kontener tekstur do przydzielenia kontrolkom.
	\param gui Referencja na obiekt interfejsu.
	\param tag Wskaznik na tag 
	\param parent
	\param tags
	*/
	static bool LoadScheme(char* fname,char* node,XE_CONTAINER<C_GUI_EVENT>& eventprocs,XE_CONTAINER<XE_ELM_TEXTURE>& textures,XE_GUI& gui,XE_MARKUP::PTAG tag=0,XE_GUI::CONTROL* parent=0,XE_MARKUP* tags=0);
};

#ifdef XE_CANIMP

C_GUI_CONTROL::C_GUI_CONTROL()
{
	DoEventsProc=0;
	RenderInsideProc=0;
}

void C_GUI_CONTROL::DoEvents()
{
	if(DoEventsProc)DoEventsProc(this);
}

void C_GUI_CONTROL::RenderInside()
{
	if(RenderInsideProc)RenderInsideProc(this);
}

void C_GUI_LOADER::ExecuteActions(XE_GUI::CONTROL* control,char* text,XE_GUI& gui)
{
	if(!control)return;
	XE_STRING act=text;
	XE_STRING _act;
	act.Replace(_act,"\n"," ");
	_act.Replace(act,"\r"," ");
	_act.Clear();
	act.EscapeSeq();
	XE_GUI::CONTROL* my=control;
	void* var=0;
	int vartype=0; //0: null; 1: file; 2: string; 3: bool; 4: texture; 5: style; 'i': integer; 'd': dword; 'h': half; 'r': real; 'f': halfvector; 'v': vector
	char* delim=" ";
	XE_CONTAINER<C_GUI_VARIABLE> vars;
	vars("DeltaTime")->data=new float(XE_EVENTS::Use().DeltaTime);
	vars("DeltaTime")->type='h';
	vars("DeltaTimeVector")->data=new XE_HALFVECTOR(XE_EVENTS::Use().DeltaTime,XE_EVENTS::Use().DeltaTime,XE_EVENTS::Use().DeltaTime);
	vars("DeltaTimeVector")->type='f';
	vars("SystemTime")->data=new float(XE_EVENTS::Use().Time);
	vars("SystemTime")->type='h';
	vars("SystemTimeVector")->data=new XE_HALFVECTOR(XE_EVENTS::Use().Time,XE_EVENTS::Use().Time,XE_EVENTS::Use().Time);
	vars("SystemTimeVector")->type='f';
	vars("WindowWidth")->data=new float((float)gui.GetWindow()->Width);
	vars("WindowWidth")->type='h';
	vars("WindowHeight")->data=new float((float)gui.GetWindow()->Height);
	vars("WindowHeight")->type='h';
	vars("WindowSize")->data=new XE_HALFVECTOR((float)gui.GetWindow()->Width,(float)gui.GetWindow()->Height);
	vars("WindowSize")->type='f';
	vars("WindowName")->data=new XE_STRING(gui.GetWindow()->Name);
	vars("WindowName")->type=2;
	XE_STRING word;
	unsigned int off=0;
	off=act.Search(word,delim,off);
	do
	{
		if(word==";"||word=="")
		{
			if(!off)break;
			off=act.Search(word,delim,off);
			continue;
		}
		else
		if(word=="exit")
			break;
		else
		if(word=="variable")
		{
			if(!off)break;
			off=act.Search(word,delim,off);
			XE_STRING n=word;
			if(!off)break;
			off=act.Search(word,delim,off);
			if(word!="as")break;
			if(!off)break;
			off=act.Search(word,delim,off);
			if(vars(XEF_FIND,n).IsEmpty())
			{
				if(word=="string")
				{
					vars(n)->type=2;
					vars(n)->data=new XE_STRING;
				}
				else
				if(word=="boolean")
				{
					vars(n)->type=3;
					vars(n)->data=new bool;
				}
				else
				if(word=="texture")
				{
					vars(n)->type=4;
					vars(n)->data=new XE_ELM_TEXTURE;
				}
				else
				if(word=="style")
				{
					vars(n)->type=5;
					vars(n)->data=new XE_GUI::STYLE::ELM;
				}
				else
				if(word=="integer")
				{
					vars(n)->type='i';
					vars(n)->data=new int;
				}
				else
				if(word=="dword"||word=="flag")
				{
					vars(n)->type='d';
					vars(n)->data=new unsigned int;
				}
				else
				if(word=="half")
				{
					vars(n)->type='h';
					vars(n)->data=new float;
				}
				else
				if(word=="real")
				{
					vars(n)->type='r';
					vars(n)->data=new double;
				}
				else
				if(word=="halfvector")
				{
					vars(n)->type='f';
					vars(n)->data=new XE_HALFVECTOR;
				}
				else
				if(word=="vector")
				{
					vars(n)->type='v';
					vars(n)->data=new XE_VECTOR;
				}
			}
		}
		else
		if(word=="select")
		{
			if(!off)break;
			off=act.Search(word,delim,off);
			if(word=="by")
			{
				if(!off)break;
				off=act.Search(word,delim,off);
				if(word=="name")
				{
					if(!off)break;
					off=act.Search(word,delim,off);
					XE_STRING temp;
					if(word.Get()[0]=='\'')
					{
						if(word.Get()[word.Length()-1]=='\'')
						{
							if(word.Length()>2)
								temp.Copy(&word.Get()[1],word.Length()-2);
						}
						else
						{
							temp<<(&word.Get()[1]);
							do
							{
								if(!off)break;
								off=act.Search(word," ",off);
								if(word.Get()[word.Length()-1]!='\'')
									temp<<" "<<word;
								else
								{
									XE_STRING _temp;
									_temp.Copy(word,word.Length()-1);
									temp<<" "<<_temp;
									break;
								}
							}
							while(true);
						}
					}
					else
						temp=word;
					if(gui.ControlNames(XEF_FIND,temp).IsEmpty())break;
					my=gui.ControlNames.Access(temp);
				}
			}
			else
			if(word=="parent")
			{
				if(!my->GetParent())break;
				my=my->GetParent();
			}
			else
			if(word=="this")
				my=control;
		}
		else
		if(word=="set"||word=="add"||word=="subtract"||word=="multiply"||word=="divide")
		{
			XE_STRING optype=word;
			if(!off)break;
			off=act.Search(word,delim,off);
			if(word=="variable")
			{
				if(!off)break;
				off=act.Search(word,delim,off);
				if(vars(XEF_FIND,word).IsEmpty())break;
				var=vars(word)->data;
				vartype=vars(word)->type;
			}
			else
			if(word=="Order")
			{
				var=&my->Order;
				vartype='h';
			}
			else
			if(word=="Events")
			{
				var=&my->Events;
				vartype='d';
			}
			else
			if(word=="Behaviour")
			{
				var=&my->Behaviour;
				vartype='d';
			}
			else
			if(word=="Position")
			{
				var=&my->Position;
				vartype='f';
			}
			else
			if(word=="Size")
			{
				var=&my->Size;
				vartype='f';
			}
			else
			if(word=="Offset")
			{
				var=&my->Offset;
				vartype='f';
			}
			else
			if(word=="ChildOffset")
			{
				var=&my->ChildOffset;
				vartype='f';
			}
			else
			if(word=="MarginTop")
			{
				var=&my->MarginTop;
				vartype='h';
			}
			else
			if(word=="MarginBottom")
			{
				var=&my->MarginBottom;
				vartype='h';
			}
			else
			if(word=="MarginLeft")
			{
				var=&my->MarginLeft;
				vartype='h';
			}
			else
			if(word=="MarginRight")
			{
				var=&my->MarginRight;
				vartype='h';
			}
			else
			if(word=="CutMarginTop")
			{
				var=&my->CutMarginTop;
				vartype='h';
			}
			else
			if(word=="CutMarginBottom")
			{
				var=&my->CutMarginBottom;
				vartype='h';
			}
			else
			if(word=="CutMarginLeft")
			{
				var=&my->CutMarginLeft;
				vartype='h';
			}
			else
			if(word=="CutMarginRight")
			{
				var=&my->CutMarginRight;
				vartype='h';
			}
			else
			if(word=="Active")
			{
				var=&my->Active;
				vartype=3;
			}
			else
			if(word=="Visible")
			{
				var=&my->Visible;
				vartype=3;
			}
			else
			if(word=="Hitable")
			{
				var=&my->Hitable;
				vartype=3;
			}
			else
			if(word=="NonCorrected")
			{
				var=&my->NonCorrected;
				vartype=3;
			}
			else
			if(word=="CutArea")
			{
				var=&my->CutArea;
				vartype=3;
			}
			else
			if(word=="Text")
			{
				var=&my->Text;
				vartype=2;
			}
			else
			if(word=="Extend")
			{
				var=&my->Extend;
				vartype=1;
			}
			else
			if(word=="Icon")
			{
				var=&my->Icon;
				vartype=4;
			}
			else
			if(word=="StyleActive")
			{
				var=&my->StyleActive;
				vartype=5;
			}
			else
			if(word=="StyleUnactive")
			{
				var=&my->StyleUnactive;
				vartype=5;
			}
			else
			if(word=="Behaviour")
			{
				var=&my->Behaviour;
				vartype='d';
			}
			if(!off)break;
			off=act.Search(word,delim,off);
			if(!(optype=="set"&&word=="to")&&!(optype=="add"&&word=="to")&&!(optype=="subtract"&&word=="with")&&!(optype=="multiply"&&word=="by")&&!(optype=="divide"&&word=="by"))break;
			if(!off)break;
			off=act.Search(word,delim,off);
			if(word=="variable")
			{
				if(!off)break;
				off=act.Search(word,delim,off);
				if(vars(XEF_FIND,word).IsEmpty())break;
				if(vars(word)->type==2&&vartype==2)
				{
					if(optype=="set")
						((XE_STRING*)var)->Set(((XE_STRING*)vars(word)->data)->Get());
					else
					if(optype=="add")
						*(XE_STRING*)var<<((XE_STRING*)vars(word)->data)->Get();
					else
					if(optype=="subtract")
					{
						XE_STRING t;
						((XE_STRING*)var)->Replace(t,((XE_STRING*)vars(word)->data)->Get(),"");
						((XE_STRING*)var)->Set(t);
					}
				}
				else
				if(vars(word)->type==3&&vartype==3)
				{
					if(optype=="set")
						*((bool*)var)=*(bool*)vars(word)->data;
					else
					if(optype=="add"||optype=="subtract")
						*((bool*)var)=!(*(bool*)vars(word)->data);
				}
				else
				if(vars(word)->type==4&&vartype==4)
				{
					if(optype=="set")
						*((XE_ELM_TEXTURE*)var)=*(XE_ELM_TEXTURE*)vars(word)->data;
				}
				else
				if(vars(word)->type==5&&vartype==5)
				{
					if(optype=="set")
						*((XE_GUI::STYLE::ELM*)var)=*(XE_GUI::STYLE::ELM*)vars(word)->data;
				}
				else
				if(vars(word)->type=='i'&&vartype=='i')
				{
					if(optype=="set")
						*((int*)var)=*(int*)vars(word)->data;
					else
					if(optype=="add")
						*((int*)var)+=*(int*)vars(word)->data;
					else
					if(optype=="subtract")
						*((int*)var)-=*(int*)vars(word)->data;
					else
					if(optype=="multiply")
						*((int*)var)*=*(int*)vars(word)->data;
					else
					if(optype=="divide")
						if(*(int*)vars(word)->data!=0)
							*((int*)var)/=*(int*)vars(word)->data;
				}
				else
				if(vars(word)->type=='d'&&vartype=='d')
				{
					if(optype=="set")
						*((unsigned int*)var)=*(unsigned int*)vars(word)->data;
					else
					if(optype=="add")
						*((unsigned int*)var)+=*(unsigned int*)vars(word)->data;
					else
					if(optype=="subtract")
						*((unsigned int*)var)-=*(unsigned int*)vars(word)->data;
					else
					if(optype=="multiply")
						*((unsigned int*)var)*=*(unsigned int*)vars(word)->data;
					else
					if(optype=="divide")
						if(*(unsigned int*)vars(word)->data!=0)
							*((unsigned int*)var)/=*(unsigned int*)vars(word)->data;
				}
				else
				if(vars(word)->type=='h'&&vartype=='h')
				{
					if(optype=="set")
						*((float*)var)=*(float*)vars(word)->data;
					else
					if(optype=="add")
						*((float*)var)+=*(float*)vars(word)->data;
					else
					if(optype=="subtract")
						*((float*)var)-=*(float*)vars(word)->data;
					else
					if(optype=="multiply")
						*((float*)var)*=*(float*)vars(word)->data;
					else
					if(optype=="divide")
						if(*(float*)vars(word)->data!=0)
							*((float*)var)/=*(float*)vars(word)->data;
				}
				else
				if(vars(word)->type=='r'&&vartype=='r')
				{
					if(optype=="set")
						*((double*)var)=*(double*)vars(word)->data;
					else
					if(optype=="add")
						*((double*)var)+=*(double*)vars(word)->data;
					else
					if(optype=="subtract")
						*((double*)var)-=*(double*)vars(word)->data;
					else
					if(optype=="multiply")
						*((double*)var)*=*(double*)vars(word)->data;
					else
					if(optype=="divide")
						if(*(double*)vars(word)->data!=0)
							*((double*)var)/=*(double*)vars(word)->data;
				}
				else
				if(vars(word)->type=='f'&&vartype=='f')
				{
					if(optype=="set")
						*((XE_HALFVECTOR*)var)=*(XE_HALFVECTOR*)vars(word)->data;
					else
					if(optype=="add")
						*((XE_HALFVECTOR*)var)+=*(XE_HALFVECTOR*)vars(word)->data;
					else
					if(optype=="subtract")
						*((XE_HALFVECTOR*)var)-=*(XE_HALFVECTOR*)vars(word)->data;
					else
					if(optype=="multiply")
						*((XE_HALFVECTOR*)var)*=*(XE_HALFVECTOR*)vars(word)->data;
					else
					if(optype=="divide")
						*((XE_HALFVECTOR*)var)/=*(XE_HALFVECTOR*)vars(word)->data;
				}
				else
				if(vars(word)->type=='v'&&vartype=='v')
				{
					if(optype=="set")
						*((XE_VECTOR*)var)=*(XE_VECTOR*)vars(word)->data;
					else
					if(optype=="add")
						*((XE_VECTOR*)var)+=*(XE_VECTOR*)vars(word)->data;
					else
					if(optype=="subtract")
						*((XE_VECTOR*)var)-=*(XE_VECTOR*)vars(word)->data;
					else
					if(optype=="multiply")
						*((XE_VECTOR*)var)*=*(XE_VECTOR*)vars(word)->data;
					else
					if(optype=="divide")
						*((XE_VECTOR*)var)/=*(XE_VECTOR*)vars(word)->data;
				}
			}
			else
			if(word=="string")
			{
				if(!off)break;
				off=act.Search(word,delim,off);
				XE_STRING temp;
				if(word.Get()[0]=='\'')
				{
					if(word.Get()[word.Length()-1]=='\'')
					{
						if(word.Length()>2)
							temp.Copy(&word.Get()[1],word.Length()-2);
					}
					else
					{
						temp<<(&word.Get()[1]);
						do
						{
							if(!off)break;
							off=act.Search(word," ",off);
							if(word.Get()[word.Length()-1]!='\'')
								temp<<" "<<word;
							else
							{
								XE_STRING _temp;
								_temp.Copy(word,word.Length()-1);
								temp<<" "<<_temp;
								break;
							}
						}
						while(true);
					}
				}
				else
					temp=word;
				if(optype=="set")
				{
					if(vartype==1)
					{
						((XE_FILE*)var)->Free();
						((XE_FILE*)var)->WriteString(temp);
					}
					else
					if(vartype==2)
						((XE_STRING*)var)->Set(temp);
				}
				else
				if(optype=="add")
				{
					if(vartype==1)
						((XE_FILE*)var)->WriteString(temp);
					else
					if(vartype==2)
						*((XE_STRING*)var)<<temp;
				}
				else
				if(optype=="subtract")
				{
					if(vartype==2)
					{
						XE_STRING r;
						((XE_STRING*)var)->Replace(r,temp,"");
						((XE_STRING*)var)->Set(r);
					}
				}
			}
			else
			if(word=="boolean")
			{
				if(!off)break;
				off=act.Search(word,delim,off);
				bool b=false;
				if(word=="true")
					b=true;
				if(optype=="set")
				{
					if(vartype==3)
						*(bool*)var=b;
				}
				else
				if(optype=="add"||optype=="subtract")
				{
					if(vartype==3)
						if(b)
							*(bool*)var=!(*(bool*)var);
				}
			}
			else
			if(word=="texture")
			{
				if(!off)break;
				off=act.Search(word,delim,off);
				XE_ELM_TEXTURE t;
				XE_STRING temp;
				if(word.Get()[0]=='\'')
				{
					if(word.Get()[word.Length()-1]=='\'')
					{
						if(word.Length()>2)
							temp.Copy(&word.Get()[1],word.Length()-2);
					}
					else
					{
						temp<<(&word.Get()[1]);
						do
						{
							if(!off)break;
							off=act.Search(word," ",off);
							if(word.Get()[word.Length()-1]!='\'')
								temp<<" "<<word;
							else
							{
								XE_STRING _temp;
								_temp.Copy(word,word.Length()-1);
								temp<<" "<<_temp;
								break;
							}
						}
						while(true);
					}
				}
				else
					temp=word;
				t=gui.TextureNames.Access(temp);
				if(optype=="set")
					if(vartype==4)*(XE_ELM_TEXTURE*)var=t;
			}
			else
			if(word=="style")
			{
				if(!off)break;
				off=act.Search(word,delim,off);
				XE_GUI::STYLE::ELM t;
				XE_STRING temp;
				if(word.Get()[0]=='\'')
				{
					if(word.Get()[word.Length()-1]=='\'')
					{
						if(word.Length()>2)
							temp.Copy(&word.Get()[1],word.Length()-2);
					}
					else
					{
						temp<<(&word.Get()[1]);
						do
						{
							if(!off)break;
							off=act.Search(word," ",off);
							if(word.Get()[word.Length()-1]!='\'')
								temp<<" "<<word;
							else
							{
								XE_STRING _temp;
								_temp.Copy(word,word.Length()-1);
								temp<<" "<<_temp;
								break;
							}
						}
						while(true);
					}
				}
				else
					temp=word;
				t=gui.Styles(temp);
				if(optype=="set")
					if(vartype==5)*(XE_GUI::STYLE::ELM*)var=t;
			}
			else
			if(word=="flag")
			{
				if(!off)break;
				off=act.Search(word,delim,off);
				XE_DWORD f=0;
				if(word=="EMPTY")
					f=XEF_FLAG_EMPTY;
				else
				if(word=="ALL")
					f=XEF_FLAG_ALL;
				else
				if(word=="ALL")
					f=XEF_FLAG_ALL;
				else
				if(word=="FIT_TO_EDGE_TOP")
					f=XEF_FLAG_FIT_TO_EDGE_TOP;
				else
				if(word=="FIT_TO_EDGE_BOTTOM")
					f=XEF_FLAG_FIT_TO_EDGE_BOTTOM;
				else
				if(word=="FIT_TO_EDGE_LEFT")
					f=XEF_FLAG_FIT_TO_EDGE_LEFT;
				else
				if(word=="FIT_TO_EDGE_RIGHT")
					f=XEF_FLAG_FIT_TO_EDGE_RIGHT;
				else
				if(word=="FIT_TO_EDGE")
					f=XEF_FLAG_FIT_TO_EDGE;
				else
				if(word=="INHERIT_WIDTH")
					f=XEF_FLAG_INHERIT_WIDTH;
				else
				if(word=="INHERIT_HEIGHT")
					f=XEF_FLAG_INHERIT_HEIGHT;
				else
				if(word=="INHERIT_SIZE")
					f=XEF_FLAG_INHERIT_SIZE;
				else
				if(word=="DOCK_TO_EDGE_TOP")
					f=XEF_FLAG_DOCK_TO_EDGE_TOP;
				else
				if(word=="DOCK_TO_EDGE_BOTTOM")
					f=XEF_FLAG_DOCK_TO_EDGE_BOTTOM;
				else
				if(word=="DOCK_TO_EDGE_LEFT")
					f=XEF_FLAG_DOCK_TO_EDGE_LEFT;
				else
				if(word=="DOCK_TO_EDGE_RIGHT")
					f=XEF_FLAG_DOCK_TO_EDGE_RIGHT;
				else
				if(word=="DOCK_TO_EDGE_BOTTOM_INSIDE")
					f=XEF_FLAG_DOCK_TO_EDGE_BOTTOM_INSIDE;
				else
				if(word=="DOCK_TO_EDGE_RIGHT_INSIDE")
					f=XEF_FLAG_DOCK_TO_EDGE_RIGHT_INSIDE;
				else
				if(word=="DOCK_TO_EDGE_TOP")
					f=XEF_FLAG_DOCK_TO_EDGE_TOP;
				else
				if(word=="DOCK_TO_CENTER")
					f=XEF_FLAG_DOCK_TO_CENTER;
				else
				if(word=="DOCK_TO_MIDDLE")
					f=XEF_FLAG_DOCK_TO_MIDDLE;
				else
				if(word=="CENTRALIZE")
					f=XEF_FLAG_CENTRALIZE;
				if(optype=="set")
				{
					if(vartype=='d')
						*(XE_DWORD*)var=f;
				}
				else
				if(optype=="add")
				{
					if(vartype=='d')
						*(XE_DWORD*)var|=f;
				}
				else
				if(optype=="subtract")
				{
					if(vartype=='d')
						*(XE_DWORD*)var=*(XE_DWORD*)var&~f;
				}
			}
			else
			if(word=="number")
			{
				if(!off)break;
				off=act.Search(word,delim,off);
				if(optype=="set")
					word.Convert(var);
				else
				if(optype=="add"||optype=="subtract"||optype=="multiply"||optype=="divide")
				{
					int t=word.ConvertType();
					if(t=='i')
					{
						int v=0;
						word.Convert(&v);
						if(optype=="add")
							*(int*)var+=v;
						else
						if(optype=="subtract")
							*(int*)var-=v;
						else
						if(optype=="multiply")
							*(int*)var*=v;
						else
						if(optype=="divide")
							if(v!=0)
								*(int*)var/=v;
					}
					else
					if(t=='d')
					{
						unsigned int v=0;
						word.Convert(&v);
						if(optype=="add")
							*(unsigned int*)var+=v;
						else
						if(optype=="subtract")
							*(unsigned int*)var-=v;
						else
						if(optype=="multiply")
							*(unsigned int*)var*=v;
						else
						if(optype=="divide")
							if(v!=0)
								*(unsigned int*)var/=v;
					}
					else
					if(t=='h')
					{
						float v=0;
						word.Convert(&v);
						if(optype=="add")
							*(float*)var+=v;
						else
						if(optype=="subtract")
							*(float*)var-=v;
						else
						if(optype=="multiply")
							*(float*)var*=v;
						else
						if(optype=="divide")
							if(v!=0)
								*(float*)var/=v;
					}
					else
					if(t=='r')
					{
						double v=0;
						word.Convert(&v);
						if(optype=="add")
							*(double*)var+=v;
						else
						if(optype=="subtract")
							*(double*)var-=v;
						else
						if(optype=="multiply")
							*(double*)var*=v;
						else
						if(optype=="divide")
							if(v!=0)
								*(double*)var/=v;
					}
					else
					if(t=='f')
					{
						XE_HALFVECTOR v=0;
						word.Convert(&v);
						if(optype=="add")
							*(XE_HALFVECTOR*)var+=v;
						else
						if(optype=="subtract")
							*(XE_HALFVECTOR*)var-=v;
						else
						if(optype=="multiply")
							*(XE_HALFVECTOR*)var*=v;
						else
						if(optype=="divide")
								*(XE_HALFVECTOR*)var/=v;
					}
					else
					if(t=='v')
					{
						XE_VECTOR v=0;
						word.Convert(&v);
						if(optype=="add")
							*(XE_VECTOR*)var+=v;
						else
						if(optype=="subtract")
							*(XE_VECTOR*)var-=v;
						else
						if(optype=="multiply")
							*(XE_VECTOR*)var*=v;
						else
						if(optype=="divide")
								*(XE_VECTOR*)var/=v;
					}
				}
			}
			var=0;
			vartype=0;
		}
		else
		if(word=="do")
		{
			if(!off)break;
			off=act.Search(word,delim,off);
			if(word=="ScrollSetContentSize")
			{
				XE_HALFVECTOR a0=0;
				if(!off)break;
				off=act.Search(word,delim,off);
				if(word=="using")
				{
					if(!off)break;
					off=act.Search(word,delim,off);
					int args=0;
					while(word!="now")
					{
						if(word=="number")
						{
							if(!off)break;
							off=act.Search(word,delim,off);
							if(args==0)word.Convert(&a0);
						}
						if(!off)break;
						off=act.Search(word,delim,off);
						args++;
					}
				}
				gui.ScrollSetContentSize(my,a0);
			}
			else
			if(word=="ProgressBarSetPhase")
			{
				float a0=0;
				if(!off)break;
				off=act.Search(word,delim,off);
				if(word=="using")
				{
					if(!off)break;
					off=act.Search(word,delim,off);
					int args=0;
					while(word!="now")
					{
						if(word=="number")
						{
							if(!off)break;
							off=act.Search(word,delim,off);
							if(args==0)word.Convert(&a0);
						}
						if(!off)break;
						off=act.Search(word,delim,off);
						args++;
					}
				}
				gui.ProgressBarSetPhase(my,a0);
			}
			else
			if(word=="SliderSetFactor")
			{
				float a0=0;
				if(!off)break;
				off=act.Search(word,delim,off);
				if(word=="using")
				{
					if(!off)break;
					off=act.Search(word,delim,off);
					int args=0;
					while(word!="now")
					{
						if(word=="number")
						{
							if(!off)break;
							off=act.Search(word,delim,off);
							if(args==0)word.Convert(&a0);
						}
						if(!off)break;
						off=act.Search(word,delim,off);
						args++;
					}
				}
				gui.SliderSetFactor(my,a0);
			}
			else
			if(word=="MenuCollapse")
			{
				if(!off)break;
				off=act.Search(word,delim,off);
				gui.MenuCollapse(my);
			}
			else
			if(word=="MenuExpand")
			{
				if(!off)break;
				off=act.Search(word,delim,off);
				gui.MenuExpand(my);
			}
			else
			if(word=="EditBoxPasswordMode")
			{
				bool a0=false;
				if(!off)break;
				off=act.Search(word,delim,off);
				if(word=="using")
				{
					if(!off)break;
					off=act.Search(word,delim,off);
					int args=0;
					while(word!="now")
					{
						if(word=="boolean")
						{
							if(!off)break;
							off=act.Search(word,delim,off);
							if(args==0)if(word=="true")a0=true;
						}
						if(!off)break;
						off=act.Search(word,delim,off);
						args++;
					}
				}
				gui.EditBoxPasswordMode(my,a0);
			}
			else
			if(word=="EditBoxEditMode")
			{
				bool a0=false;
				if(!off)break;
				off=act.Search(word,delim,off);
				if(word=="using")
				{
					if(!off)break;
					off=act.Search(word,delim,off);
					int args=0;
					while(word!="now")
					{
						if(word=="boolean")
						{
							if(!off)break;
							off=act.Search(word,delim,off);
							if(args==0)if(word=="true")a0=true;
						}
						if(!off)break;
						off=act.Search(word,delim,off);
						args++;
					}
				}
				gui.EditBoxEditMode(my,a0);
			}
			else
			if(word=="EditBoxSetText")
			{
				XE_STRING a0;
				if(!off)break;
				off=act.Search(word,delim,off);
				if(word=="using")
				{
					if(!off)break;
					off=act.Search(word,delim,off);
					int args=0;
					while(word!="now")
					{
						if(word=="string")
						{
							if(!off)break;
							off=act.Search(word,delim,off);
							XE_STRING temp;
							if(word.Get()[0]=='\'')
							{
								if(word.Get()[word.Length()-1]=='\'')
								{
									if(word.Length()>2)
										temp.Copy(&word.Get()[1],word.Length()-2);
								}
								else
								{
									temp<<(&word.Get()[1]);
									do
									{
										if(!off)break;
										off=act.Search(word," ",off);
										if(word.Get()[word.Length()-1]!='\'')
											temp<<" "<<word;
										else
										{
											XE_STRING _temp;
											_temp.Copy(word,word.Length()-1);
											temp<<" "<<_temp;
											break;
										}
									}
									while(true);
								}
							}
							else
								temp=word;
							if(args==0)a0=temp;
						}
						if(!off)break;
						off=act.Search(word,delim,off);
						args++;
					}
				}
				gui.EditBoxSetText(my,a0);
			}
		}
		if(!off)break;
		off=act.Search(word,delim,off);
	}
	while(off);
	XE_FOREACH(C_GUI_VARIABLE,vars,elm)
	{
		if(elm->type==2)
			delete (XE_STRING*)elm->data;
		else
		if(elm->type==3)
			delete (bool*)elm->data;
		else
		if(elm->type==4)
			delete (XE_ELM_TEXTURE*)elm->data;
		else
		if(elm->type==5)
			delete (XE_GUI::STYLE::ELM*)elm->data;
		else
		if(elm->type=='i')
			delete (int*)elm->data;
		else
		if(elm->type=='d')
			delete (unsigned int*)elm->data;
		else
		if(elm->type=='h')
			delete (float*)elm->data;
		else
		if(elm->type=='r')
			delete (double*)elm->data;
		else
		if(elm->type=='f')
			delete (XE_HALFVECTOR*)elm->data;
		else
		if(elm->type=='v')
			delete (XE_VECTOR*)elm->data;
	}
	vars.Clear();
}

bool C_GUI_LOADER::LoadScheme(char* fname,char* node,XE_CONTAINER<C_GUI_EVENT>& eventprocs,XE_CONTAINER<XE_ELM_TEXTURE>& textures,XE_GUI& gui,XE_MARKUP::PTAG tag,XE_GUI::CONTROL* parent,XE_MARKUP* tags)
{
	XE_MARKUP* xml=0;
	if(!tags)
	{
		xml=new XE_MARKUP();
		XE_FILE file;
		if(!file.Load(fname))
		return(false);
		if(!xml->Parse((char*)file.Data(),file.Size()," \t\r\n"))
		{
			file.Free();
			return(false);
		}
		file.Free();
	}
	else
		xml=tags;
	XE_MARKUP::ETAG elm;
	if(!tag)
	{
		if((*xml)(node,XE_MARKUP::FIND,0).IsEmpty())return(false);
		elm=(*xml)(node,XE_MARKUP::CREATE,0)->FirstChild();
	}
	else
		elm=tag->FirstChild();
	XE_GUI::CONTROL* control=0;
	while(!elm.IsEmpty())
	{
		bool rec=true;
		if(elm()->Name=="Include")
		{
			rec=false;
			XE_STRING f=(*xml)(".","File",XE_MARKUP::CREATE,elm.iPointer())->Value;
			XE_STRING n=(*xml)(".","Node",XE_MARKUP::CREATE,elm.iPointer())->Value;
			if(n.Length())
				LoadScheme((f.Length())?f:fname,n,eventprocs,textures,gui,0,parent);
		}
		else
		if(elm()->Name=="Control")
		{
			control=gui.Register(new C_GUI_CONTROL(),parent);
			if(control)
			{
				if((*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					gui.ControlNames.Access((*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value)=control;
				if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if((*xml)(".","RenderProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->RenderInsideProc=eventprocs.Access((*xml)(".","RenderProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
					ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
			}
		}
		else
		if(elm()->Name=="Window")
		{
			XE_HALFVECTOR p;
			XE_HALFVECTOR s;
			unsigned int f=0;
			XE_ELM_TEXTURE t;
			XE_HALFVECTOR m(0,0,0,0);
			(*xml)(".","Position",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&p,'f');
			(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
			if((*xml)(".","Caption",XE_MARKUP::CREATE,elm.iPointer())->Value=="On")f|=XEF_FLAG_CAPTION_BAR;
			if((*xml)(".","ButtonClose",XE_MARKUP::CREATE,elm.iPointer())->Value=="On")f|=XEF_FLAG_BUTTON_CLOSE;
			if((*xml)(".","ButtonFull",XE_MARKUP::CREATE,elm.iPointer())->Value=="On")f|=XEF_FLAG_BUTTON_FULLSCREEN;
			if((*xml)(".","ButtonMin",XE_MARKUP::CREATE,elm.iPointer())->Value=="On")f|=XEF_FLAG_BUTTON_MINIMALIZE;
			t=textures.Access((*xml)(".","Icon",XE_MARKUP::CREATE,elm.iPointer())->Value);
			(*xml)(".","Margin",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&m,'f');
			control=gui.WindowCreate<C_GUI_CONTROL>((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)(".","Title",XE_MARKUP::CREATE,elm.iPointer())->Value,p,s,f,t,m.X,m.Y,m.Z,m.W,parent);
			if(control)
			{
				if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if((*xml)(".","RenderProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->RenderInsideProc=eventprocs.Access((*xml)(".","RenderProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
					ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
			}
		}
		else
		if(elm()->Name=="Button")
		{
			XE_HALFVECTOR p;
			XE_HALFVECTOR s;
			XE_ELM_TEXTURE t;
			(*xml)(".","Position",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&p,'f');
			(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
			t=textures.Access((*xml)(".","Icon",XE_MARKUP::CREATE,elm.iPointer())->Value);
			control=gui.ButtonCreate<C_GUI_CONTROL>((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)("./",XE_MARKUP::CREATE,elm.iPointer())()->Text,p,s,t,parent);
			if(control)
			{
				control->Text.EscapeSeq();
				if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if((*xml)(".","RenderProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->RenderInsideProc=eventprocs.Access((*xml)(".","RenderProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
					ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
			}
		}
		else
		if(elm()->Name=="ScrollPlane")
		{
			XE_HALFVECTOR p;
			XE_HALFVECTOR s;
			XE_HALFVECTOR ss;
			XE_HALFVECTOR cs;
			XE_HALFVECTOR m(0,0,0,0);
			(*xml)(".","Position",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&p,'f');
			(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
			(*xml)(".","BarSize",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&ss,'f');
			(*xml)(".","ContentSize",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&cs,'f');
			(*xml)(".","Margin",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&m,'f');
			control=gui.ScrollCreate<C_GUI_CONTROL>((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value,p,s,ss,cs,m.X,m.Y,m.Z,m.W,parent);
			if(control)
			{
				if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if((*xml)(".","RenderProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->RenderInsideProc=eventprocs.Access((*xml)(".","RenderProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
					ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
			}
		}
		else
		if(elm()->Name=="Static")
		{
			XE_HALFVECTOR p;
			XE_HALFVECTOR s;
			(*xml)(".","Position",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&p,'f');
			(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
			control=gui.StaticCreate<C_GUI_CONTROL>((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)("./",XE_MARKUP::CREATE,elm.iPointer())()->Text,p,s,parent);
			control->Text.EscapeSeq();
			if(control)
			{
				if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if((*xml)(".","RenderProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->RenderInsideProc=eventprocs.Access((*xml)(".","RenderProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
					ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
			}
		}
		else
		if(elm()->Name=="ProgressBar")
		{
			rec=false;
			XE_HALFVECTOR p;
			XE_HALFVECTOR s;
			XE_HALFVECTOR m(0,0,0,0);
			(*xml)(".","Position",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&p,'f');
			(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
			(*xml)(".","Margin",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&m,'f');
			control=gui.ProgressBarCreate<C_GUI_CONTROL>((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value,p,s,m.X,m.Y,m.Z,m.W,parent);
			if(control)
			{
				if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
					ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
			}
		}
		else
		if(elm()->Name=="ListBox")
		{
			XE_HALFVECTOR p;
			XE_HALFVECTOR s;
			float ss;
			XE_HALFVECTOR m(0,0,0,0);
			(*xml)(".","Position",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&p,'f');
			(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
			(*xml)(".","BarSize",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&ss,'h');
			(*xml)(".","Margin",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&m,'f');
			control=gui.ListBoxCreate<C_GUI_CONTROL>((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value,p,s,ss,m.X,m.Y,m.Z,m.W,parent);
			if(control)
			{
				if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
					ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
			}
		}
		else
		if(elm()->Name=="CheckBox")
		{
			XE_HALFVECTOR p;
			XE_HALFVECTOR s;
			XE_HALFVECTOR m(0,0,0,0);
			(*xml)(".","Position",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&p,'f');
			(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
			(*xml)(".","Margin",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&m,'f');
			control=gui.CheckBoxCreate<C_GUI_CONTROL>((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value,p,s,m.X,m.Y,m.Z,m.W,parent);
			if(control)
			{
				if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
					ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
			}
		}
		else
		if(elm()->Name=="OptionBox")
		{
			XE_HALFVECTOR p;
			XE_HALFVECTOR s;
			XE_HALFVECTOR m(0,0,0,0);
			(*xml)(".","Position",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&p,'f');
			(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
			(*xml)(".","Margin",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&m,'f');
			control=gui.OptionBoxCreate<C_GUI_CONTROL>((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value,p,s,m.X,m.Y,m.Z,m.W,parent);
			if(control)
			{
				if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
					ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
			}
		}
		else
		if(elm()->Name=="Item"&&parent)
		{
			rec=false;
			parent->Extend.Seek(0);
			XE_STRING type;
			parent->Extend.ReadString(type);
			if(type=="listbox")
			{
				float s;
				(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'h');
				control=gui.ListBoxAddCell((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)("./",XE_MARKUP::CREATE,elm.iPointer())()->Text,s,parent);
				if(control)
				{
					control->Text.EscapeSeq();
					if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
						ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
				}
			}
			else
			if(type=="checkbox")
			{
				float s;
				XE_HALFVECTOR cs;
				(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'h');
				(*xml)(".","CheckSize",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&cs,'f');
				control=gui.CheckBoxAddCell((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)("./",XE_MARKUP::CREATE,elm.iPointer())()->Text,s,cs,parent);
				if(control)
				{
					control->Text.EscapeSeq();
					if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
						ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
				}
			}
			else
			if(type=="optionbox")
			{
				float s;
				XE_HALFVECTOR cs;
				(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'h');
				(*xml)(".","OptSize",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&cs,'f');
				control=gui.OptionBoxAddCell((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)("./",XE_MARKUP::CREATE,elm.iPointer())()->Text,s,cs,parent);
				if(control)
				{
					control->Text.EscapeSeq();
					if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
						ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
				}
			}
			else
			if(type=="menubutton"||type=="menuitem")
			{
				XE_HALFVECTOR s;
				XE_ELM_TEXTURE t;
				(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
				t=textures.Access((*xml)(".","Icon",XE_MARKUP::CREATE,elm.iPointer())->Value);
				control=gui.MenuAddItemButton<C_GUI_CONTROL>(parent,(*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,s,(*xml)("./",XE_MARKUP::CREATE,elm.iPointer())()->Text,t);
				if(control)
				{
					control->Text.EscapeSeq();
					if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
						((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
					if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
						ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
				}
			}
			else
			{
				parent->GetNode()->FirstChild()->Pointer()->Pointer()->Extend.Seek(0);
				XE_STRING _type;
				parent->GetNode()->FirstChild()->Pointer()->Pointer()->Extend.ReadString(_type);
				if(_type=="comboboxm")
				{
					float s;
					(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'h');
					control=gui.ComboBoxAddCell((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)("./",XE_MARKUP::CREATE,elm.iPointer())()->Text,s,parent);
					if(control)
					{
						control->Text.EscapeSeq();
						if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
							ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
					}
				}
			}
		}
		else
		if(elm()->Name=="Slider")
		{
			rec=false;
			XE_HALFVECTOR p;
			XE_HALFVECTOR s;
			(*xml)(".","Position",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&p,'f');
			(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
			control=gui.SliderCreate<C_GUI_CONTROL>((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value,p,s,parent);
			if(control)
			{
				if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
					ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
			}
		}
		else
		if(elm()->Name=="Menu")
		{
			XE_STRING type;
			if(parent)
			{
				parent->Extend.Seek(0);
				parent->Extend.ReadString(type);
			}
			if(type=="menubutton")
			{
				XE_HALFVECTOR s;
				XE_ELM_TEXTURE t;
				unsigned int ldt=XEF_FLAG_DOCK_TO_EDGE_RIGHT;
				(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
				t=textures.Access((*xml)(".","Icon",XE_MARKUP::CREATE,elm.iPointer())->Value);
				XE_STRING type=(*xml)(".","ListDockType",XE_MARKUP::CREATE,elm.iPointer())->Value;
				if(type=="TOP")ldt=XEF_FLAG_DOCK_TO_EDGE_TOP;
				else
				if(type=="BOTTOM")ldt=XEF_FLAG_DOCK_TO_EDGE_BOTTOM;
				else
				if(type=="LEFT")ldt=XEF_FLAG_DOCK_TO_EDGE_LEFT;
				else
				if(type=="RIGHT")ldt=XEF_FLAG_DOCK_TO_EDGE_RIGHT;
				else
				if(type=="LEFT-UP")ldt=XEF_FLAG_DOCK_TO_EDGE_BOTTOM_INSIDE|XEF_FLAG_DOCK_TO_EDGE_LEFT;
				else
				if(type=="RIGHT-UP")ldt=XEF_FLAG_DOCK_TO_EDGE_BOTTOM_INSIDE|XEF_FLAG_DOCK_TO_EDGE_RIGHT;
				control=gui.MenuAddItemMenu<C_GUI_CONTROL>(parent,(*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,s,(*xml)("./",XE_MARKUP::CREATE,elm.iPointer())()->Text,t,ldt);
				if(control)
				{
					control->Text.EscapeSeq();
					if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
						((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
					if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
						ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
				}
			}
			else
			{
				XE_HALFVECTOR p;
				XE_HALFVECTOR s;
				XE_ELM_TEXTURE t;
				unsigned int ldt=XEF_FLAG_DOCK_TO_EDGE_BOTTOM;
				(*xml)(".","Position",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&p,'f');
				(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
				t=textures.Access((*xml)(".","Icon",XE_MARKUP::CREATE,elm.iPointer())->Value);
				XE_STRING type=(*xml)(".","ListDockType",XE_MARKUP::CREATE,elm.iPointer())->Value;
				if(type=="TOP")ldt=XEF_FLAG_DOCK_TO_EDGE_TOP;
				else
				if(type=="BOTTOM")ldt=XEF_FLAG_DOCK_TO_EDGE_BOTTOM;
				else
				if(type=="LEFT")ldt=XEF_FLAG_DOCK_TO_EDGE_LEFT;
				else
				if(type=="RIGHT")ldt=XEF_FLAG_DOCK_TO_EDGE_RIGHT;
				else
				if(type=="LEFT-UP")ldt=XEF_FLAG_DOCK_TO_EDGE_BOTTOM_INSIDE|XEF_FLAG_DOCK_TO_EDGE_LEFT;
				else
				if(type=="RIGHT-UP")ldt=XEF_FLAG_DOCK_TO_EDGE_BOTTOM_INSIDE|XEF_FLAG_DOCK_TO_EDGE_RIGHT;
				control=gui.MenuCreate<C_GUI_CONTROL>((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value,p,s,(*xml)("./",XE_MARKUP::CREATE,elm.iPointer())()->Text,t,ldt,parent);
				if(control)
				{
					control->Text.EscapeSeq();
					if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
						((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
					if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
						ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
				}
			}
		}
		else
		if(elm()->Name=="EditBox")
		{
			rec=false;
			XE_HALFVECTOR p;
			XE_HALFVECTOR s;
			(*xml)(".","Position",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&p,'f');
			(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
			control=gui.EditBoxCreate<C_GUI_CONTROL>((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value,p,s,(*xml)("./",XE_MARKUP::CREATE,elm.iPointer())()->Text,((*xml)(".","Password",XE_MARKUP::CREATE,elm.iPointer())->Value=="On")?true:false,parent);
			if(control)
			{
				if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
					ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
			}
		}
		else
		if(elm()->Name=="Group")
		{
			XE_HALFVECTOR p;
			XE_HALFVECTOR s;
			(*xml)(".","Position",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&p,'f');
			(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
			control=gui.GroupCreate((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value,p,s,(*xml)(".","Title",XE_MARKUP::CREATE,elm.iPointer())->Value,parent);
			if(control)
			{
				if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
					ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
			}
		}
		else
		if(elm()->Name=="ComboBox")
		{
			XE_HALFVECTOR p;
			XE_HALFVECTOR s;
			XE_HALFVECTOR ll=0;
			float ss;
			XE_HALFVECTOR m(0,0,0,0);
			unsigned int ldt=XEF_FLAG_DOCK_TO_EDGE_BOTTOM;
			(*xml)(".","Position",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&p,'f');
			(*xml)(".","Size",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&s,'f');
			(*xml)(".","ListSize",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&ll,'f');
			(*xml)(".","BarSize",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&ss,'h');
			(*xml)(".","Margin",XE_MARKUP::CREATE,elm.iPointer())->Value.Convert(&m,'f');
			XE_STRING type=(*xml)(".","ListDockType",XE_MARKUP::CREATE,elm.iPointer())->Value;
			if(type=="TOP")ldt=XEF_FLAG_DOCK_TO_EDGE_TOP;
			else
			if(type=="BOTTOM")ldt=XEF_FLAG_DOCK_TO_EDGE_BOTTOM;
			else
			if(type=="LEFT")ldt=XEF_FLAG_DOCK_TO_EDGE_LEFT;
			else
			if(type=="RIGHT")ldt=XEF_FLAG_DOCK_TO_EDGE_RIGHT;
			else
			if(type=="LEFT-UP")ldt=XEF_FLAG_DOCK_TO_EDGE_TOP|XEF_FLAG_DOCK_TO_EDGE_LEFT;
			else
			if(type=="RIGHT-UP")ldt=XEF_FLAG_DOCK_TO_EDGE_TOP|XEF_FLAG_DOCK_TO_EDGE_RIGHT;
			control=gui.ComboBoxCreate<C_GUI_CONTROL>((*xml)(".","Skin",XE_MARKUP::CREATE,elm.iPointer())->Value,(*xml)(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value,p,s,ll,ss,(*xml)(".","Text",XE_MARKUP::CREATE,elm.iPointer())->Value,ldt,m.X,m.Y,m.Z,m.W,parent);
			if(control)
			{
				if((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value.Length())
					((C_GUI_CONTROL*)control)->DoEventsProc=eventprocs.Access((*xml)(".","EventProc",XE_MARKUP::CREATE,elm.iPointer())->Value);
				if(!((*xml)(".","OnLoad",XE_MARKUP::FIND,elm.iPointer()).IsEmpty()))
					ExecuteActions(control,(*xml)(".","OnLoad",XE_MARKUP::CREATE,elm.iPointer())->Value,gui);
			}
		}
		else
			rec=false;
		if(rec)
			if(elm->Count())
				LoadScheme(fname,node,eventprocs,textures,gui,elm.iPointer(),control,xml);
		elm.Next();
	}
	if(!tags)delete xml;
	return(true);
}

#endif /* XE_CANIMP */

} /* namespace: Com */
} /* namespace: XeCore */

#endif /* XE_COMPONENT_GUI_H */
